%% RTR robot 8 kinematics
% Ryan Brown
% 11/10/2015
%% Housekeeping
clc; clear all; close all
%% Declare t as symbolic
syms t L1 L2 L3 L4 real
% generalized coordinates
q1 = sym('q1(t)');
q2 = sym('q2(t)');
q3 = sym('q3(t)');
%% Kinematics of link 1
% Translational Kinematics for C1
rC1 = [0 0 L1]
vC1 = diff(rC1,t)
aC1 = diff(vC1,t)

% Rotational Kinematics for Link 1
omega_10_ = [0 0 diff(q1,t)];
fprintf('omega of link 1 wrt 0= \n\n')
pretty(omega_10_)
fprintf('alpha of link 1 wrt 0= \n\n')
alpha_10_ = diff(omega_10_,t);
pretty(alpha_10_)

%% Kinematics of link 2
% Translational Kinematics for C2
rC2 = [0 0 L1+q2]
vC2 = diff(rC2,t)
aC2 = diff(vC2,t)

%% Kinematics of link 3
fprintf('rC3= \n\n')
rC3 = [L3*cos(q1+q3) L3*sin(q1+q3) (L1+q2+L2)];
pretty(rC3)
fprintf('vC3= \n\n')
vC3 = diff(rC3,t);
pretty(vC3)
fprintf('aC3= \n\n')
aC3 = diff(vC3,t);
pretty(aC3)


% Rotational Kinematics for Link 3
omega_30_ = omega_10_+cross([0 0 diff(q3,t)],rC3);
fprintf('omega of link 3 wrt 0= \n\n')
pretty(omega_30_)
fprintf('alpha of link 3 wrt 0= \n\n')
alpha_30_ = diff(omega_30_,t);
pretty(alpha_30_)