%% Newton 2 DOF Number 4
%Ryan Brown
%10/13/2015
%% Housekeeping
clc;
clear all;
%% Givens
L = 1;        
m1 = 1;         
m2 = 1;         
g = 10;
c = 10;
k = 100;
%% Calculations
G1 = [0 -m1*g 0];
G2 = [0 -m2*g 0];
IO = m1 * L^2/3 ;
IC2 = m1 * L^2/12 ;
syms t
q1 = sym('q1(t)');
q2 = sym('q2(t)');
s1 = sin(sym('q1(t)'));
c1 = cos(sym('q1(t)')); 
s2 = sin(sym('q2(t)'));
c2 = cos(sym('q2(t)')); 
dq1 = diff(q1,t);
dq2 = diff(q2,t);
omega1_ = [0 0 dq1];
omega2_ = [0 0 dq2];
alpha1_ = diff(omega1_,t);
alpha2_ = diff(omega2_,t);
xC1 = (L/2)*c1; yC1 = (L/2)*s1;
rC1_ = [xC1 yC1 0];
xB = L*c1; yB = L*s1;
rB_ = [xB yB 0];
xC2 = xB+(L/2)*c2; yC2 = yB+(L/2)*s2;
rC2_ = [xC2 yC2 0];
vC2_ = diff(rC2_,t);
aC2_ = diff(vC2_,t);
vC1_ = diff(rC1_,t);
aC1_ = diff(vC1_,t);
% EOMS
F_21 = G2 - m1 * aC2_ ;
M_21 = c *(omega2_- omega1_) + k *(q2-q1) ;
M_O = cross(rC1_,G1) + cross(rB_ , F_21)+ M_21 ;
eq_I = IO * alpha1_ - M_O ;
eq_Iz = simplify(eq_I(3)) ;

M_C2 = cross(rB_-rC2_ , -F_21)- M_21 ;
eq_II = IC2 * alpha2_ - M_C2 ;

out = {diff('q1(t)',t,2),diff('q2(t)',t,2),diff('q1(t)',t),...
       diff('q2(t)',t),'q1(t)','q2(t)'};

in = {'ddq1','ddq2','x(2)','x(4)','x(1)','x(3)'};

eq1 = subs(eq_Iz,out,in);
eq2 = subs(eq_II(3),out,in);

solv = solve(eq1,eq2,'ddq1,ddq2');
ddq1s_2 = solv.ddq1;
ddq2s = solv.ddq2;

dx2dt = char(ddq1s_2);
dx4dt = char(ddq2s);

t0 = 0; 
tf = 20; 
ti = [t0 tf];
%% ODE45
%IC's
q_1 = pi/2; q_2 = pi;
x0 = [q_1 0 q_2 0];
%Solve
[ts,xs] = ode45(@eom4,0:0.25:5,x0);
%Store
x1 = xs(:,1); 
x2 = xs(:,2);
x3 = xs(:,3); 
x4 = xs(:,4); 
%% Plot
figure (1)
subplot(4,1,1)
plot(ts,xs(:,1),'r','LineWidth',1.5)
xlabel('t (sec)')
ylabel('q1 (rad)')
grid
subplot(4,1,2)
plot(ts,xs(:,3),'--r','LineWidth',1.5)
xlabel('t (sec)')
ylabel('dq1 (rad/s)')
grid
subplot(4,1,3)
plot(ts,xs(:,3),'c','LineWidth',1.5)
xlabel('t (sec)')
ylabel('q2 (rad)')
grid
subplot(4,1,4)
plot(ts,xs(:,4),'--c','LineWidth',1.5)
xlabel('t (sec)')
ylabel('dq2 (rad/s)')
grid
Time = (ts);
q1_rad = xs(:,1).*180/pi;
dq1_rad_s = xs(:,2).*180/pi;
q2_rad = xs(:,3);
dq2_rad_s = xs(:,4);
Results = table(Time,q1_rad,dq1_rad_s,q2_rad,dq2_rad_s)
figure(2)
grid on
for i=1:1:length(x1)
    pause(0.35)
    clf
    xAn = x3(i);
    yAn = 0;
    xBn = L*cos(x1(i));
    yBn = L*sin(x1(i));
    xCn = xBn+L*cos(x3(i));
    yCn = yBn+L*sin(x3(i));
    Ov = zeros(length(x1(i)),1);
    xO = Ov; 
    yO = Ov; 
    xlabel('x(m)') 
    ylabel('y(m)')
    axis([-2.1 2.1 -2.1 1.6])
    hold on
    plot_pivot0(0,0,0.06,0)
    plot([xO xBn],[yO yBn],'k','LineWidth',3)
    plot([xBn xCn],[yBn yCn],'k','LineWidth',3)
end