%% Newton 2 DOF Number 3
%Ryan Brown
%10/13/2015
%% Housekeeping
clc;
clear all;
%% Givens
m1 = 1;
m2 = 1;
L = 1;
IC = m2*L^2/12;
g = 9.81;
beta = 45*pi/180;
v0 = 2;
G1 = [0 -m1*g 0];
G2 = [0 -m2*g 0];
%% Calculations
% Pos Vel Acc
syms t %define symbolic variable t
rA = sym('r1(t)'); %define position of point A based on symbolic t
rB = sym('r2(t)'); %define position of point B based on symbolic t
rA_ = [rA 0 0]; % put into vector form (only in x direction)
rB_ = [rA+cos(beta)*rB rB*sin(beta) 0]; %put into vector form
vA = diff(rA_,t); % define velocity as first deriv of rA
vB = diff(rB_,t); % define velocity as first deriv of rB

aA = diff(vA,t); %define acceleration as second deriv of rA
aB = diff(vB,t); %define acceleration as second deriv of rB
olist = {aA(1),vA(1)};
nlist = {0,v0};

v1y = subs(vA,olist,nlist);
a1y_ = subs(aA,olist,nlist);
% Forces
syms  F21 F01y F21y 

F01_ = [0 F01y 0];
F21_ = [-F21*cos(beta) -F21*sin(beta) 0];
F12_ = -F21_;

eom1 = -m1*a1y_ + F01_ + F21_ + G1;
eom1y = eom1(2);
eom1x = eom1(1);

eom2 = m2*aB + F12_ + G2;
eom2y = eom2(2);
eom2x = eom2(1);

sol = solve(eom1y,eom1x,F01y,F21);
F01ys = sol.F01y;
F21ys = sol.F21;

eqn1 = subs(eom2y,{'F01y','F21'},{F01ys,F21ys});
eqn2 = subs(eom2x,{'F01y','F21'},{F01ys,F21ys});

oldvar  = {diff('r1(t)',t,2), diff('r2(t)',t,2)};
newvar = {'ddr1','ddr2'};

eq1 = subs(eqn1,oldvar,newvar);
eq2 = subs(eqn2,oldvar,newvar);

sol2 = solve(eq1,eq2,'ddr1','ddr2');

ddr1s = sol2.ddr1;
ddr2s = sol2.ddr2;

dx1dt = v0;
dx2dt = char(ddr2s);

eqns_pro3 = 'f';  

fid = fopen(strcat(eqns_pro3,'.m'),'w+');

fprintf(fid,'function dx = ');
fprintf(fid,eqns_pro3); fprintf(fid,'(t,x)\n');

fprintf(fid,'dx = zeros(3,1);\n');
fprintf(fid,'dx(1) =' );

fprintf(fid, num2str(dx1dt));
fprintf(fid, ';\n');
fprintf(fid,'dx(2) = x(3);\n');
fprintf(fid,'dx(3) = ');

fprintf(fid, char(dx2dt));
fprintf(fid,';');
fclose(fid);

cd(pwd);
%% ODE45
%IC's
t0 = 0; tf = 1; time = [0:0.01:tf];
x0 = [0 0 0];
% ode45 input
[t, xs] = ode45(str2func(eqns_pro3), time, x0);
%store results
t0 = 0; tf = 5; time = [0:0.5:tf];
x0 = [0 0 0];
% ode45 input
[t, xp] = ode45(str2func(eqns_pro3), time, x0);
x1 = xs(:,1);
x2 = xs(:,2);
x3 = xs(:,3); 
Time = (t);
r = xp(:,1);
Velocity = xp(:,2);
Acceleration = xp(:,3);
%Display Values
Results = table(Time,r,Velocity,Acceleration)
%% Plot Results
for i = 1:length(xs)
    clf
%Link1-A    
    xA = 1-x1(i);
    yA = 0;
    rA_ = [xA,yA,0];
%Link1-B    
    xB = xA + x2(i)*cos(beta);
    yB = -x2(i)*sin(beta);
    rB_ = [xB,yB,0];
%Link2        
    xC = xA + L*cos(beta);
    yC = -L*sin(beta);
    rC_ = [xC,yC,0];
    
    xlabel('x(m)') 
    ylabel('y(m)')
    grid on
    axis([-1 2 -1.25 .75])
    hold on
  plot_slider(rA_(1),rA_(2),0.2,0)
  plot([xA xC],[yA yC],'r','LineWidth',1.5)
  plot_slider(rB_(1),rB_(2),0.15,beta)
%Condition for end of slider  
  if yB <= yC 
  break
  end
  
    pause(0.040);
end