%% NE 2 DOF: Problem 2
% Ryan Brown
% Due 10/13/2015
%% Housekeeping
clc;
clear all;
clf;
%% Givens
m = 1; %kg
L = 1; %m
g = 9.81; % m/s/s
%% Funtion for calculating magnitude
mag = @(x) sqrt(x(1)^+x(2)^2);
%% Calculations
% Moment of inertia for link 2 about center
IC=m*L^2/12;
% Moment of inertia for link 2 about point A
IA = IC + m*(.5)^2;
%% Symbolic Setup
%Define symbolic variables
syms t f21 N
%define symbolic DOF
r = sym('r(t)');
theta = sym('theta(t)');
%calculate symbolic angular velocity and acceleration
omega_ = [0 0 diff(theta,t)];
alpha_ = diff(omega_,t);
%define symbolic cosine and sine functions
c = cos(theta);
s = sin(theta);
%define symbolic position of A
rA_ = [r 0 0];
rB_ = [r+c*L r+s*L 0];
%define symbolic vel and accel of A
vA_ = diff(rA_,t);
aA_ = diff(vA_,t);
%define gravity vector
G_ = [0 -m*g 0];
%define F21 vector
F21_ = [-c*f21 -s*f21 0];
%define N vector
N_ = [0 N 0];
%Link 1 EOM
eomF1_ = -m*aA_ + F21_ + N_; % ma=sum(Forces)
eomF1x = eomF1_(1);
eomF1y = eomF1_(2);
%Link 2 EOMs
eomMA_ = -IA*alpha_+cross((rB_-rA_)/2,G_); %IAalpha=sum(Moments)
eomMAz = eomMA_(3); % scalar of moment equation
eomF2_ = G_+(-F21_); % ma=sum(Forces)
eomF2x = eomF2_(1);
eomF2y = eomF2_(2);
% make equation string for solving
eomF2ys = char(eomF2y);
eq0 = char('=0');
eomF2ys = strcat(eomF2ys,eq0);
sol1 = solve(eomF2ys,f21);
%plug solution into eomF1x
eomF1x = subs(eomF1x,f21,sol1);
%substitute in shorthands
slist = {diff('theta(t)',t,2),diff('r(t)',t,2),diff('theta(t)',t),...
    diff('r(t)',t),'theta(t)','r(t)'};
nlist = {'ddth','ddr','x2','x4','x1','x2'};
Eq1 = subs(eomMAz,slist,nlist);
Eq2 = subs(eomF1x,slist,nlist);
%solve equations for second derivative
sol2 = solve(Eq1,Eq2,'ddth','ddr');
eq1 = sol2.ddth;
eq2 = sol2.ddr;
%% ODE45
%define symbolic variables for first order eqns
syms x1 x2 x3 x4 real
%x_n|fuction
%x1 = theta(t)
%x2 = d(theta(t))/dt = dx1/dt
%x3 = r(t)
%x4 = d(r(t))/dt = dx3/dt
%make derivative variables
dx1 = sym('x2'); %dx1=d(theta(t)/dt=x2
dx2 = char(eq1); % store equation ddths sovled above
dx3 = sym('x4'); %dx3=d(r(t)/dt=x4
dx4 = char(eq2);  % store equation ddrs sovled above
%store derivative variables in matrix of derivatives
dx_ = [dx1; dx2; dx3; dx4];
%convert derivative variables into a function eomRT_
eomRT_ = matlabFunction(dx_,'vars',{t,[x1;x2;x3;x4]});
%time vector
t0 = 0;  tf = .8; time = [0 tf];
%inital conditions
x0 = [pi/9 0 0.5 0]; % initial conditions
%Set options and event to track when theta = 0
optionP7 = odeset('RelTol',1e-3,'MaxStep',1e-3);
%use ode45 to solve for eomRT using time vector, ICs, and options above
[t, xs] = ode45(eomRT_, time, x0, optionP7);
% Store results
x1 = xs(:,1); 
x2 = xs(:,2);
x3 = xs(:,3); 
x4 = xs(:,4);  
%plot pivot angle and rod position
figure(1)
subplot(2,1,1),plot(t,x1*180/pi,'r'),...
xlabel('t (s)'),ylabel('\theta (deg)'),grid,...
subplot(2,1,2),plot(t,x3,'b'),...
xlabel('t (s)'),ylabel('r (m)'),grid
%solve for values and display
[ts,xs] = ode45(eomRT_,0:0.1:.8,x0); 
Time = (ts);
Theta = xs(:,1).*180/pi;
Omega = xs(:,2).*180/pi;
r = xs(:,3);
Velocity = xs(:,4);
%Display Values
Results = table(Time,Theta,Omega,r,Velocity)
%% Animation
figure(2)
text_size = 12;
%link 1
textAx = 4.2;
textAy = 4.2;
text(textAx, textAy,'A','FontSize',text_size)
%link 2
it = 1;
figure(2)
hold on
for i = 1:length(x1)
    clf
    plot_slider(x3(it),1,0.2,0)
    grid on
    axis([-3 3 -3 3])
    hold on
    xB = x3(it)+cos(x1(it))*L;
    yB = 1+sin(x1(it))*L;
    plot([x3(it) xB],[1 yB],'r','LineWidth',1.5)
    it = it + 5;
    if it >925 && it < 1065
        it = 1135;
    end
    if it > length(x1)
        break
    end
    pause(.001)
end