%% Position Analysis
% Ryan Brown
% MECH5170
% Mechanism 9, Index 1
% Due: 9/1/2015
%% Housekeeping
clc, clear all;
%% Initialize Variables
AB = .22; %m
AC = .08; %m
CD = .20; %m
DE = .60; %m
% Define Jont A Position
rA = [0 0 0];
% Define Jont C Position
rC = [.08 0 0];
%% Begin Loop
i= 1 ; %initialize increment element
for phi=240:18:360+240, %stationary phi in assignment in 240
    %% Calculate Joint B location
    rB(1) = AB*cosd(phi);
    rB(2) = AB*sind(phi);
    rB(3) = 0;
    %% Calculate angle of BC to horizontal
    aBC=  atand((rC(2)-rB(2))/(rC(1)-rB(1)));
    % Condition angle according to quadrant
    if rB(1)<= rC(1)
        aBC = aBC + 180;
    end
    if rB(1) > rC(1)
        aBC = 360 + aBC;
    end
    %% Calculate angle of CD
    aCD = aBC - 90;
    %% Calculate position of joint D
    rD(1) = CD*cosd(aCD)+rC(1);
    rD(2) = CD*sind(aCD)+rC(2);
    rD(3) = 0;
    %% Calculate position of joint E
    % E is along X axis, so y coordinate is 0
    rE(2)= 0;
    rE(3)=0;
    sym xEsol;
    eqnE ='(xEsol-rD(1))^2+(rE(2)-rD(2))^2=DE^2';
    solE = solve(eqnE,'xEsol');
    xE1=eval(solE(1));
    xE2=eval(solE(2));
    %Select correct solution
    if xE1>rD(1)
        rE(1)=xE1;
    else
        rE(1)=xE2;
    end
    %% Save midpoint of link DE
    xD2(i) = (rD(1)+rE(1))/2;
    yD2(i) = (rD(2)+rE(2))/2;
    i = i+1;
    %% Plot
    title('Mechanism 9 Motion Over 360'),...
    axis manual
    axis equal
    hold on
    grid on
    axis([-0.5 1 -0.5 .5])
    xlabel('x (m)'), ylabel('y (m)') 
    gr=plot([rA(1),rB(1)],[rA(2),rB(2)],'k-o',[rB(1),rC(1)],[rB(2),rC(2)],'b-o',...
        [rC(1),rD(1)],[rC(2),rD(2)],'r-o',[rD(1),rE(1)],[rD(2),rE(2)],'g-o');
    pause(.1);
    delete(gr);
    plot(xD2, yD2, '-k.','Color','red'); %Plot path of midpoint of DE
end
%% Plot Final Position
plot([rA(1),rB(1)],[rA(2),rB(2)],'k-o',[rB(1),rC(1)],[rB(2),rC(2)],'b-o',...
        [rC(1),rD(1)],[rC(2),rD(2)],'r-o',[rD(1),rE(1)],[rD(2),rE(2)],'g-o');
text(rA(1),rA(2),'  A') 
text(rB(1),rB(2),'  B') 
text(rC(1),rC(2),'  C') 
text(rD(1),rD(2),'  D') 
text(rE(1),rE(2),'  E') 
