function []= plot_slider( x, y, scale_factor, theta )
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Class:      MECH 6710 - Kinematics and Dynamics of Robots              %
%  Instructor: Dan B. Marghitu                                            %
%  Author:     Jordan Britt                                               %
%  Date:       Aug 21 2012                                                %
%                                                                         %
%  Description:                                                           %
%               This method will plot a square box to represent a slider  %
%               given a scale factor the box can be made larger or smaller%
%               the box can be rotated as well via the input variable     %
%               'theta'.  Note: by default this box has sides of length 1 %
%                                                                         %
%  Input Parameters: [ x, y, scale_factor, theta ]                        %
%  Ouput Paramaters: [none]                                               %
%                                                                         %
%  Explanation of Input Variables:                                        %
%                                                                         %
%       x = Location on X-axis of the center of the slider                %
%       y = Location on Y-axis of the center of the slider                %
%       scale_factor = scales slider by this factor to make it appear     %
%                      larger or smaller                                  %
%       theta = angle (in radians) that slider should be plotted          %
%                                                                         %
%  Key Variables:                                                         % 
%                                                                         %
%                 resolution: How fine the circle is plotted (radians)    %
%                 angle_of_base: angle of the legs of the base (radians)  %
%                 hash_mark_length: how long the hash marks appera (m)    %
%                                                                         %
%  Example Call: plot_slider( 1, 3, 3, pi/4)                              %
%                This will plot the slider at (1,3) with a scale factor of%
%                3 at an angle of pi/4 radians (45 degrees)               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                   DRAW OUTLINE OF BOX                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
TL_corner = [-0.5;  0.5]; % Top    Left  Corner of Box
TR_corner = [+0.5;  0.5]; % Top    Right Corner of Box
BL_corner = [-0.5; -0.5]; % Bottom Left  Corner of Box
BR_corner = [+0.5; -0.5]; % Bottom Right Corner of Box

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%               ROTATE AND TRANSLATE BOX                                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
R = [ cos(theta) -sin(theta); sin(theta) cos(theta)]; % Rotation Matrix

box = repmat([x;y],1,5) + R * scale_factor * ...
              [TL_corner, TR_corner, BR_corner, BL_corner, TL_corner];
          
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                            Plotting                                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          
plot(box(1,:), box(2,:),'k')