% RR chain
% Lagrange e.o.m.

clear all; clc; close all %house keeping

%declare symbolic variables
syms t L1 L2 L m1 m2 m g 

%Define q1 and q2 as functions of t
q1 = sym('q1(t)');
q2 = sym('q2(t)');

%define c1/2 and s1/2 as functions of respective theta above
c1 = cos(q1); s1 = sin(q1);
c2 = cos(q2); s2 = sin(q2);

% Define Lengths of rods as symbolic L
L1 = L; L2 = L;

% Define Vector rB (position of connection on link)
xB = L1*c1; 
yB = L1*s1; 
rB_ = [xB yB 0];

% Define center of link 1
rC1_ = rB_/2; 
% Define velocity and acceleration of center of link 1
vC1_ = diff(rC1_,t);
aC1_ = diff(vC1_,t);

% Define Vector rD (position of end of second link)
xD = xB + L2*c2; 
yD = yB + L2*s2; 
rD_ = [xD yD 0];

% Define Center of link 2
rC2_ = (rB_ + rD_)/2; 
% Define velocity and acceleration of center of link 2
vC2_ = diff(rC2_,t);
aC2_ = diff(vC2_,t);

% Define symbolic angular velocities (as vectors)
omega1_ = [0 0 diff(q1,t)]; 
omega2_ = [0 0 diff(q2,t)]; 

% Define givens
m1 = m; m2 = m;
IO = m1*L1^2/3; 
IC2 = m2*L2^2/12;

% kinetic energy of the link 1
T1 = IO*omega1_*omega1_.'/2;
fprintf('T1 = \n')
pretty(T1); fprintf('\n')

% kinetic energy of the link 2
T2 = m2*vC2_*vC2_.'/2 + IC2*omega2_*omega2_.'/2;
T2 = simplify(T2);
fprintf('T2 = \n')
pretty(T2); fprintf('\n')

% total kinetic energy
T = simplify(T1 + T2);
fprintf('T = \n') 
pretty(T); fprintf('\n')

%deriv(f,g(t)) differentiates f with respect to g(t)

% dT/d(dq)
Tdq1 = deriv(T, diff(q1,t));
Tdq2 = deriv(T, diff(q2,t));
fprintf('dT/d(dq1) = \n'); pretty(simplify(Tdq1)); 
fprintf('\n')
fprintf('dT/d(dq2) = \n'); pretty(simplify(Tdq2)); 
fprintf('\n')

% d(dT/d(dq))/dt
Tt1 = diff(Tdq1, t);
Tt2 = diff(Tdq2, t);
fprintf('d dT/d(dq1)/dt = \n'); 
pretty(simplify(Tt1)); 
fprintf('\n')
fprintf('d dT/d(dq2)/dt = \n'); 
pretty(simplify(Tt2)); 
fprintf('\n')

% dT/dq
Tq1 = deriv(T, q1);
Tq2 = deriv(T, q2);
fprintf('dT/dq1 = \n'); pretty(Tq1); 
fprintf('\n')
fprintf('dT/dq2 = \n'); pretty(Tq2); 
fprintf('\n')

% left hand side of Lagrange's eom
LHS1 = Tt1 - Tq1;
LHS2 = Tt2 - Tq2;

% generalized active forces
G1_ = [0 -m1*g 0]; 
G2_ = [0 -m2*g 0];

% partial derivatives
rC1_1 = deriv(rC1_, q1); 
rC2_1 = deriv(rC2_, q1);
rC1_2 = deriv(rC1_, q2); 
rC2_2 = deriv(rC2_, q2);

c = 0.5;
M21_= c*(omega2_-omega1_);
M01_=-c*omega1_;

w1_1 = deriv(omega1_, diff(q1,t)); 
w2_1 = deriv(omega2_, diff(q1,t));
w1_2 = deriv(omega1_, diff(q2,t)); 
w2_2 = deriv(omega2_, diff(q2,t));

% generalized active force Q1
Q1 = rC1_1*G1_.' + rC2_1*G2_.' ...
+w1_1*M01_.'+w1_1*M21_.'+w2_1*(-M21_).';
% generalized active force Q2
Q2 = rC1_2*G1_.' + rC2_2*G2_.' ...
+w1_2*M01_.'+w1_2*M21_.'+w2_2*(-M21_).';

fprintf('Q1 = \n'); pretty(simplify(Q1)); 
fprintf('\n')
fprintf('Q2 = \n'); pretty(simplify(Q2)); 
fprintf('\n')

% first Lagrange's equation of motion
Lagrange1 = LHS1-Q1;
% second Lagrange's equation of motion
Lagrange2 = LHS2-Q2;

fprintf('e.o.m:  \n')
pretty(simplify(Lagrange1)); 
fprintf(' = 0 \n\n\n')
pretty(simplify(Lagrange2)); 
fprintf(' = 0 \n')

data = {L, m, g};
datn = {1 , 1, 9.81};

Lagran1 = subs(Lagrange1, data, datn);
Lagran2 = subs(Lagrange2, data, datn);

ql = {diff(q1,t,2), diff(q2,t,2),...
    diff(q1,t), diff(q2,t), q1, q2};    
qf = ...
{'ddq1', 'ddq2', 'x(2)', 'x(4)', 'x(1)', 'x(3)'};

% ql                    qf
%----------------------------
% diff('q1(t)',t,2) -> 'ddq1'
% diff('q2(t)',t,2) -> 'ddq2'
%   diff('q1(t)',t) -> 'x(2)'
%   diff('q2(t)',t) -> 'x(4)'
%           'q1(t)' -> 'x(1)'
%           'q2(t)' -> 'x(3)' 


Lagra1 = subs(Lagran1, ql, qf);
Lagra2 = subs(Lagran2, ql, qf);

% solve e.o.m. for ddq1, ddq2
sol = solve(Lagra1,Lagra2,'ddq1', 'ddq2');
Lagr1 = sol.ddq1;
Lagr2 = sol.ddq2;

% system of ODE 
dx2dt = char(Lagr1); 
dx4dt = char(Lagr2);

fid = fopen('RRLAGeom.m','w+'); 
fprintf(fid,'function dx=RRLAGeom(t,x)\n');
fprintf(fid,'dx = zeros(4,1);\n');
fprintf(fid,'dx(1) = x(2);\n');
fprintf(fid,'dx(2) = ');
fprintf(fid,dx2dt);
fprintf(fid,';\n');
fprintf(fid,'dx(3) = x(4);\n');
fprintf(fid,'dx(4) = ');
fprintf(fid,dx4dt);
fprintf(fid,';');
fclose(fid); cd(pwd);

t0 = 0;  tf = 15; time = [0 tf];

q10 = -88*pi/180; 
q20 = -89*pi/180; 

x0 = [q10 0 q20 0]; 

[tsn,xs] = ode45(@RRLAGeom,0:1:5,x0);

fprintf('Results \n\n')
fprintf ...
('    t(s)     q1(rad)  dq1(rad/s) q2(rad)  dq2(rad/s) \n') 
[tsn,xs]


% Results 
% 
%     t(s)     q1(rad)  dq1(rad/s) q2(rad)  dq2(rad/s) 
% 
% ans =
% 
%          0   -1.5359         0   -1.5533         0
%     1.0000   -1.5917   -0.0271   -1.6006   -0.0418
%     2.0000   -1.5579    0.0461   -1.5533    0.0665
%     3.0000   -1.5742   -0.0526   -1.5747   -0.0747
%     4.0000   -1.5761    0.0476   -1.5790    0.0667
%     5.0000   -1.5592   -0.0339   -1.5540   -0.0466
