%% Lagrange 2 DOF Number 4
%Ryan Brown
%10/22/2015
%% Housekeeping
clc;
clear all;
%% Newton
%Givens
m1 = 1;             %kg
m2 = m1;            %kg
L = 1 ;             %m
g = 9.81;           %m/s^2
beta = 45*pi/180;   %degree
v0 = 2;             %m/s
G1 = [0 -m1*g 0];
G2 = [0 -m2*g 0];
IC = m2*L^2/12;

syms t 

rA = sym('r1(t)');
rB = sym('r2(t)');
rA_ = [rA 0 0];
rB_ =[rA+rB*cos(beta) rB*sin(beta) 0];
vA = diff(rA_,t); 
aA = diff(vA,t);
vB = diff(rB_,t);
aB = diff(vB,t);
slist = {aA(1),vA(1)};
nlist = {0,v0};
v1y = subs(vA,slist,nlist);
a1y_ = subs(aA,slist,nlist);
syms  F21 F01y F21y 
F01_ = [0 F01y 0];
F21_ = [-F21*cos(beta) -F21*sin(beta) 0];
F12_ = -F21_;
eom1 = -m1*a1y_ + F01_ + F21_ + G1;
eom1y = eom1(2);
eom1x = eom1(1);
eom2 = m2*aB + F12_ + G2;
eom2y = eom2(2);
eom2x = eom2(1);
sol = solve(eom1y,eom1x,F01y,F21);
F01ys = sol.F01y;
F21ys = sol.F21;
eqn1 = subs(eom2y,{'F01y','F21'},{F01ys,F21ys});
eqn2 = subs(eom2x,{'F01y','F21'},{F01ys,F21ys});
oldvar  = {diff('r1(t)',t,2), diff('r2(t)',t,2)};
newvar = {'ddr1','ddr2'};
eq1 = subs(eqn1,oldvar,newvar);
eq2 = subs(eqn2,oldvar,newvar);
sol2 = solve(eq1,eq2,'ddr1','ddr2');
ddr1s = sol2.ddr1;
ddr2s = sol2.ddr2;
%% ODE45
dx1dt = v0;
dx2dt = char(ddr2s);
eqns_pro3 = 'f'; 
fid = fopen(strcat(eqns_pro3,'.m'),'w+');
fprintf(fid,'function dx = ');
fprintf(fid,eqns_pro3); fprintf(fid,'(t,x)\n');
fprintf(fid,'dx = zeros(3,1);\n');
fprintf(fid,'dx(1) =' );
fprintf(fid, num2str(dx1dt));
fprintf(fid, ';\n');
fprintf(fid,'dx(2) = x(3);\n');
fprintf(fid,'dx(3) = ');
fprintf(fid, char(dx2dt));
fprintf(fid,';');
fclose(fid);
cd(pwd);
t0 = 0;  
tf = 5; 
time = [0:0.5:tf];
x0 = [0 0 0];
[t, xp] = ode45(str2func(eqns_pro3), time, x0);
Time = (t);
Q1 = xp(:,1);
dQ1dt = xp(:,2);
Q2 = xp(:,3);
%Display Values
NewtonResults  = table(Time,Q1,dQ1dt,Q2)
%% Lagrange
clear all;
syms  t;
% Constants
m1 = 1;
m2 = m1;
L = 1;
g = 9.81;
I0 = 1;
Ic= m2 * L^2/12;
G_1 =[0 -m1*g 0];
G_2 =[0 -m2*g 0];
beta = 45*pi/180;
q1 = sym('q1(t)'); 
q2 = sym('q2(t)');
rA_ = [q1 0 0]; 
xB = q1+q2*cos(beta);
yB = -q2*sin(beta);
rB_ = [xB yB 0];
xC = q1+(L/2)*cos(beta);
yC = -(L/2)*sin(beta);
rC = [xC yC 0]; 
vA=diff(rA_,t);
vB=diff(rB_,t);
vC=diff(rC,t);
%Kinetic Energies
T1 = m1*(vA*vA.')/2;
T2 = m2*(vB*vB.')/2;
T = simplify(T1 + T2);
%Partial Diffs
Tdq1 = deriv(T, diff(q1,t));
Tdq2 = deriv(T, diff(q2,t));
%LHSs
LHS1 = diff(Tdq1, t) - deriv(T, q1);
LHS2 = diff(Tdq2, t) - deriv(T, q2);
%Forces
Q1 = deriv(rA_, q1) * G_1.' +deriv(rB_, q1) * G_2.';
Q2 = deriv(rA_, q2) * G_1.' +deriv(rB_, q2) * G_2.';
%EOMs
eom1 = LHS1-Q1;
eom2 = LHS2-Q2;
%substitute
slist = {diff(q1,t,2), diff(q2,t,2), diff(q1,t), diff(q2,t), q1, q2};    
nlist ={'ddq1', 'ddq2', 'x(2)', 'x(4)', 'x(1)', 'x(3)'};
eq1 = subs(eom1, slist, nlist);
eq2 = subs(eom2, slist, nlist);
%Solve Eqns
sol = solve(eq1,eq2,'ddq1', 'ddq2');
Eq1 = sol.ddq1;
Eq2 = sol.ddq2;
%% ODE45
dx2dt = char(Eq1); 
dx4dt = char(Eq2);
fid = fopen('RRLAGeom.m','w+'); 
fprintf(fid,'function dx=RRLAGeom(t,x)\n');
fprintf(fid,'dx = zeros(4,1);\n');
fprintf(fid,'dx(1) = x(2);\n');
fprintf(fid,'dx(2) = ');
fprintf(fid,dx2dt);
fprintf(fid,';\n');
fprintf(fid,'dx(3) = x(4);\n');
fprintf(fid,'dx(4) = ');
fprintf(fid,dx4dt);
fprintf(fid,';');
fclose(fid); cd(pwd);
%ICs
t0 = 0;  tf = 5; time = [0 tf];
x0 = [.5 0 .5 0]; 
% ODE45
[tsn,xs] = ode45(@RRLAGeom,0:.001:5,x0);
x1 = xs(:,1); 
x2 = xs(:,2);
x3 = xs(:,3); 
x4 = xs(:,4);  
[t,xp] = ode45(@RRLAGeom,0:.5:5,x0);
Time = (t);
Q1 = xp(:,1);
dQ1dt = xp(:,2);
Q2 = xp(:,3);
%Display Values
LagrangeResults  = table(Time,Q1,dQ1dt,Q2)
%% Plot
figure (1)
subplot(2,1,1)

plot(tsn,xs(:,1),'g','LineWidth',2.0)
xlabel('t (sec)')
ylabel('r1 (m)')
grid
subplot(2,1,2)

plot(tsn,xs(:,2),'b','LineWidth',2.0)
xlabel('t (sec)')
ylabel('r2 (m)')
grid
%% Animation
figure(2)
for i = 1:5:length(x1)
    
pause(0.0025); 
clf
grid on
axis([-1.5 2.5 -2 1.25])
hold on
drawnow

xBn = (x1(i)+x3(i))*cos(beta);
yBn = -x3(i)*sin(beta);

xAn = x1(i);
yAn = 0;

Ov = zeros(length(x1(i)),1);

xO = Ov; 
yO = Ov; 

plot([-2 2],[0 0],'k--','LineWidth',2)
plot_slider(0.15+xBn,yBn,0.25,beta)
plot_slider(xAn,yAn,0.25,0)

xlabel('x(m)')
ylabel('y(m)')

xAnn= x1(i);
yAnn= 0;

xBnn=(x1(i)+x3(i))*cos(beta);
yBnn= -x3(i)*sin(beta);

xCnn= xAnn + L*cos(beta);
yCnn= -L*sin(beta);

plot([xAnn xCnn],[yAnn yCnn],'r','LineWidth',3)
if xAn < 0.25
    break
end
end