%% Lagrange 2 DOF Number 3
%Ryan Brown
%10/22/2015
%% Housekeeping
clc;
clear all;
%% Newton
%Givens
m1 = 1;
m2 = 1;
L = 1;
IC = m2*L^2/12;
g = 9.81;
beta = 45*pi/180;
v0 = 2;
G1 = [0 -m1*g 0];
G2 = [0 -m2*g 0];
%% Calculations
% Pos Vel Acc
syms t %define symbolic variable t
rA = sym('r1(t)'); %define position of point A based on symbolic t
rB = sym('r2(t)'); %define position of point B based on symbolic t
rA_ = [rA 0 0]; % put into vector form (only in x direction)
rB_ = [rA+cos(beta)*rB rB*sin(beta) 0]; %put into vector form
vA = diff(rA_,t); % define velocity as first deriv of rA
vB = diff(rB_,t); % define velocity as first deriv of rB

aA = diff(vA,t); %define acceleration as second deriv of rA
aB = diff(vB,t); %define acceleration as second deriv of rB
olist = {aA(1),vA(1)};
nlist = {0,v0};

v1y = subs(vA,olist,nlist);
a1y_ = subs(aA,olist,nlist);
% Forces
syms  F21 F01y F21y 

F01_ = [0 F01y 0];
F21_ = [-F21*cos(beta) -F21*sin(beta) 0];
F12_ = -F21_;

eom1 = -m1*a1y_ + F01_ + F21_ + G1;
eom1y = eom1(2);
eom1x = eom1(1);

eom2 = m2*aB + F12_ + G2;
eom2y = eom2(2);
eom2x = eom2(1);

sol = solve(eom1y,eom1x,F01y,F21);
F01ys = sol.F01y;
F21ys = sol.F21;

eqn1 = subs(eom2y,{'F01y','F21'},{F01ys,F21ys});
eqn2 = subs(eom2x,{'F01y','F21'},{F01ys,F21ys});

oldvar  = {diff('r1(t)',t,2), diff('r2(t)',t,2)};
newvar = {'ddr1','ddr2'};

eq1 = subs(eqn1,oldvar,newvar);
eq2 = subs(eqn2,oldvar,newvar);

sol2 = solve(eq1,eq2,'ddr1','ddr2');

ddr1s = sol2.ddr1;
ddr2s = sol2.ddr2;

dx1dt = v0;
dx2dt = char(ddr2s);

eqns_pro3 = 'f';  

fid = fopen(strcat(eqns_pro3,'.m'),'w+');

fprintf(fid,'function dx = ');
fprintf(fid,eqns_pro3); fprintf(fid,'(t,x)\n');

fprintf(fid,'dx = zeros(3,1);\n');
fprintf(fid,'dx(1) =' );

fprintf(fid, num2str(dx1dt));
fprintf(fid, ';\n');
fprintf(fid,'dx(2) = x(3);\n');
fprintf(fid,'dx(3) = ');

fprintf(fid, char(dx2dt));
fprintf(fid,';');
fclose(fid);

cd(pwd);
%% ODE45
%IC's
t0 = 0; tf = 1; time = [0:0.01:tf];
x0 = [0 0 0];
% ode45 input
[t, xs] = ode45(str2func(eqns_pro3), time, x0);
%store results
t0 = 0; tf = 5; time = [0:0.5:tf];
x0 = [0 0 0];
% ode45 input
[t, xp] = ode45(str2func(eqns_pro3), time, x0);
x1 = xs(:,1);
x2 = xs(:,2);
x3 = xs(:,3); 
Time = (t);
r = xp(:,1);
Velocity = xp(:,2);
Acceleration = xp(:,3);
%Display Values
NewtonResults  = table(Time,r,Velocity,Acceleration)
%% Lagrange
clear all;
syms  t
%Constants
m1 = 1;
m2 = m1;
L = 1;
g = 9.81;
I0 = 1;
Ic = m2*L^2/12;
G_1=[0 -m1*g 0];
G_2=[0 -m2*g 0];
c = 10;
k = 100;
%Theta1
q1 = sym('q1(t)');
%Theta2
q2 = sym('q2(t)'); 
s1 = sin(q1);
c1 = cos(q1);
s2 = sin(q2);
c2 = cos(q2);
xB = L*cos(q1);
yB = L*sin(q1);
rB=[xB yB 0];
xC1 = L/2*c1;
yC1 = L/2*s1;
rC1_ = [xC1 yC1 0];
xC2 = xB+L/2*c2;
yC2 = yB+L/2*s2;
rC2_ = [xC2 yC2 0];
vC1=diff(rC1_,t);
vC2=diff(rC2_,t);
omega1= [0 0 diff('q1(t)',t)];
omega2= [0 0 diff('q2(t)',t)];
omega1z=omega1(3);
omega2z=omega2(3);
M21=c*(omega2-omega1)+k*(q2-q1);
M12=-M21;
T1 = m1*(vC1*vC1.')/2 + Ic*(omega1*omega1.')/2;
T2 = m2*(vC2*vC2.')/2 + Ic*(omega2*omega2.')/2;
T = simplify(T1 + T2);
Tdq1 = deriv(T, diff(q1,t));
Tdq2 = deriv(T, diff(q2,t));
LHS1 = diff(Tdq1, t) - deriv(T, q1);
LHS2 = diff(Tdq2, t); - deriv(T, q2);
Q1 = deriv(rC1_, q1) * G_1.' +deriv(rC2_, q1) * G_2.'...
    +deriv(omega2, q1)* M21.'+deriv(omega2, q1)* M12.';
Q2 = deriv(rC1_, q2) * G_1.' +deriv(rC2_, q2) * G_2.'...
    +deriv(omega2, q2)* M21.'+deriv(omega2, q2)* M12.';
eom1 = LHS1-Q1;
eom2 = LHS2-Q2;
ql = {diff(q1,t,2), diff(q2,t,2), diff(q1,t), diff(q2,t), q1, q2};    
qf ={'ddq1', 'ddq2', 'x(2)', 'x(4)', 'x(1)', 'x(3)'};
Lagra1 = subs(eom1, ql, qf);
Lagra2 = subs(eom2, ql, qf);
sol = solve(Lagra1,Lagra2,'ddq1', 'ddq2');
eq1 = sol.ddq1;
eq2 = sol.ddq2;
%% ODE45
dx2dt = char(eq1); 
dx4dt = char(eq2);
fid = fopen('RRLAGeom.m','w+'); 
fprintf(fid,'function dx=RRLAGeom(t,x)\n');
fprintf(fid,'dx = zeros(4,1);\n');
fprintf(fid,'dx(1) = x(2);\n');
fprintf(fid,'dx(2) = ');
fprintf(fid,dx2dt);
fprintf(fid,';\n');
fprintf(fid,'dx(3) = x(4);\n');
fprintf(fid,'dx(4) = ');
fprintf(fid,dx4dt);
fprintf(fid,';');
fclose(fid); cd(pwd);
q_1 = pi/3;
q_2 = pi/6;
x0 = [q_1 0 q_2 0];
[tsn,xs] = ode45(@RRLAGeom,0:.001:5,x0);
x1 = xs(:,1); 
x2 = xs(:,2);
x3 = xs(:,3); 
x4 = xs(:,4);  
t0 = 0; tf = 5; time = [0:0.5:tf];
[t,xp] = ode45(@RRLAGeom,time,x0);
Time = (t);
Q1 = xp(:,1);
dQ1dt = xp(:,2);
Q2 = xp(:,3);
dQ2dt = xp(:,4);
%Display Values
LagrangeResults  = table(Time,Q1,dQ1dt,Q2,dQ2dt)
figure(1)
%% Animation
for i=1:8:length(x1) 
    clf
    grid on
    xBn = L*cos(x1(i));
    yBn = L*sin(x1(i));
    xCn = xBn+L*cos(x3(i));
    yCn = yBn+L*sin(x3(i));  
    Ov = zeros(length(x1(i)),1);    
    xO = Ov; 
    yO = Ov; 
    xlabel('x(m)')
    ylabel('y(m)')
    axis([-1.75 1.75 -2 1.75])
    hold on
    drawnow 
    plot_pivot0(0,0,0.06,0)
    plot([xO xBn],[yO yBn],'r','LineWidth',2)
    plot([xBn xCn],[yBn yCn],'r','LineWidth',2)
    pause(0.0000001) 
end