%% Lagrange 2 DOF Number 2
%Ryan Brown
%10/22/2015
%% Housekeeping
clc;
clear all;
%% Newton
%Constants
m1 = 1;
m2 = 1;
L = 1; 
g = 9.81; 
Io = 1; 
IC = (m2*L^2)/12;
G1 = [0 -m1*g 0];
G2 = [0 -m2*g 0];
thetai = pi/180*60;
% Declare symbolic variables
syms t q1 q2 x1 x2 x3 x4 ddq1 ddq2
%theta(t)
q1 = sym('q1(t)');
omega_ = [ 0 0 diff(q1,t)];
alpha_ = diff(omega_,t);
%r(t)
q2 = sym('q2(t)');
s = sin(q1);
c = cos(q1);
xC = q2 + L*c/2;
yC = L*s/2;
rC_ = [ xC yC 0];
rA_ = [ q2 0 0];
vR = diff(rC_,t);
aR = diff(vR,t);
vA = diff(rA_,t);
aA = diff(vA,t);
%Force of Link 2 on Link 1
syms F21x F21y F01
F01_ = [ 0 F01 0];
F21_ = [F21x F21y 0];
%Moment Equation Link1
eq1 = -m1*aA + F01_ +  F21_ + G2;
eq1x = eq1(1);
eq1y = eq1(2);
%Acceleration Equation Link2
eq2 = -m1*aR -F21_ + G2;
eq2x = eq2(1);
eq2y = eq2(2);
%Moment Equation Link2
M2 = -IC*alpha_ - cross((rA_-rC_), -F21_);
M2_ = M2(3);
% Solving Equations for forces
sol = solve(eq1x,eq1y,eq2y,F21x,F21y,F01);
F01s_ = sol.F01;
f21x_ = sol.F21x;
f21y_ = sol.F21y;
%Put forces into diff eqs
eom1 = subs(eq2x,{'F21x','F21y'},{f21x_,f21y_});
eom2 = subs(M2_,{'F21x','F21y'},{f21x_,f21y_});
%Substitute
slist = {diff(q1,t,2), diff(q2,t,2), diff(q1,t), diff(q2,t), q1, q2};    
nlist ={'ddq1', 'ddq2', 'x2', 'x4', 'x1', 'x3'};
eq1 = subs(eom1,slist,nlist);
eq2 = subs(eom2,slist,nlist);

%Solve eqns for second derivs
sol = solve(eq1,eq2,'ddq1','ddq2');
Eq1 = sol.ddq1;
Eq2 = sol.ddq2;
%% ODE45
dx2dt=char(Eq1);
dx4dt=char(Eq2);
%make derivative variables
dx1 = sym('x2'); %dx1=d(theta(t)/dt=x2
dx2 = char(Eq1); % store equation ddths sovled above
dx3 = sym('x4'); %dx3=d(r(t)/dt=x4
dx4 = char(Eq2);  % store equation ddrs sovled above
%store derivative variables in matrix of derivatives
dx_ = [dx1; dx2; dx3; dx4];

%convert derivative variables into a function eomRT_
eomRT_ = matlabFunction(dx_,'vars',{t,[x1;x2;x3;x4]});

%Initial Conditions
%time
t0 = 0; tf = 1; time = [0 tf];
%angles
q10 = 25*pi/180; q20 = .5; 
%position
x0 = [q10 0 q20 0]; 
% ODE45
[tsn,xs] = ode45(eomRT_,0:.001:5,x0);
x1 = xs(:,1);      
x2 = xs(:,2);
x3 = xs(:,3);     
x4 = xs(:,4);  
[ts,xs] = ode45(eomRT_,0:0.1:1,x0); 
Time = (ts);
Theta = xs(:,1).*180/pi;
Omega = xs(:,2).*180/pi;
q2 = xs(:,3);
Velocity = xs(:,4);
%Display Values
NewtonResults = table(Time,Theta,Omega,q2,Velocity)
%% Lagrange
clear all;
syms t q1 q2 x1 x2 x3 x4 ddq1 ddq2
%Constants
m1 = 1;
m2 = m1;
L = 1;
g = 9.81;
I0 = 1;
Ic = m2*L^2/12;
G=[0 -m1*g 0];
%theta(t)
q1 = sym('q1(t)');
omega=[0 0 diff(q1,t)];
%r(t)
q2 = sym('q2(t)');  


rA_ = [q2 0 0]; 
s = sin(q1);
c = cos(q1);
xC = q2+L/2*c; 
yC = L/2*s;
rC_ = [xC yC 0]; 
vA=diff(rA_,t);
aA=diff(rA_,t,2);
vC=diff(rC_,t);
aC=diff(rC_,t,2);
% Kinetic Energy
T1 = m1*(vA*vA.')/2;
T2 = m2*(vC*vC.')/2 + Ic*(omega*omega.')/2;
T = simplify(T1 + T2);
%Take Partial Derivative of T wrt dq
Tdq1 = deriv(T,diff(q1,t));
Tdq2 = deriv(T,diff(q2,t));

% Define LHS of equations
LHS1 = diff(Tdq1,t) - deriv(T,q1);
LHS2 = diff(Tdq2,t) - deriv(T,q2);

% Potention Energy
Q1 = deriv(rC_,q1)*G.';
Q2 = deriv(rC_,q2)*G.';

% Combine to form EOMs
eom1 = LHS1 - Q1;
eom2 = LHS2 - Q2;

%Substitute
slist = {diff(q1,t,2), diff(q2,t,2), diff(q1,t), diff(q2,t), q1, q2};    
nlist ={'ddq1', 'ddq2', 'x2', 'x4', 'x1', 'x3'};
eq1 = subs(eom1,slist,nlist);
eq2 = subs(eom2,slist,nlist);

%Solve eqns for second derivs
sol = solve(eq1,eq2,'ddq1','ddq2');
Eq1 = sol.ddq1;
Eq2 = sol.ddq2;
%% ODE45
dx2dt=char(Eq1);
dx4dt=char(Eq2);
%make derivative variables
dx1 = sym('x2'); %dx1=d(theta(t)/dt=x2
dx2 = char(Eq1); % store equation ddths sovled above
dx3 = sym('x4'); %dx3=d(r(t)/dt=x4
dx4 = char(Eq2);  % store equation ddrs sovled above
%store derivative variables in matrix of derivatives
dx_ = [dx1; dx2; dx3; dx4];

%convert derivative variables into a function eomRT_
eomRT_ = matlabFunction(dx_,'vars',{t,[x1;x2;x3;x4]});

%Initial Conditions
%time
t0 = 0; tf = 1; time = [0 tf];
%angles
q10 = 25*pi/180; q20 = .5; 
%position
x0 = [q10 0 q20 0]; 
% ODE45
[tsn,xs] = ode45(eomRT_,0:.001:5,x0);
x1 = xs(:,1);      
x2 = xs(:,2);
x3 = xs(:,3);     
x4 = xs(:,4);  
[ts,xs] = ode45(eomRT_,0:0.1:1,x0); 
Time = (ts);
Theta = xs(:,1).*180/pi;
Omega = xs(:,2).*180/pi;
q2 = xs(:,3);
Velocity = xs(:,4);
%Display Values
LagrangeResults = table(Time,Theta,Omega,q2,Velocity)
%% Animation
figure(2)
text_size = 12;
%link 1
textAx = 4.2;
textAy = 4.2;
text(textAx, textAy,'A','FontSize',text_size)
%link 2
it = 1;
figure(2)
hold on
for i = 1:length(x1)
    clf
    plot_slider(x3(it),1,0.2,0)
    grid on
    axis([-3 3 -3 3])
    hold on
    xB = x3(it)+cos(x1(it))*L;
    yB = 1+sin(x1(it))*L;
    plot([x3(it) xB],[1 yB],'r','LineWidth',1.5)
    it = it + 5;
    if it >925 && it < 1065
        it = 1135;
    end
    if it > length(x1)
        break
    end
    pause(.001)
end