%% Lagrange 2 DOF Number 1
%Ryan Brown
%10/22/2015
%% Housekeeping
% clc;
clear all;
%% Magnitude Function
mag = @(x) sqrt(x(1)^2 + x(2)^2+x(3)^2);
% Givens
m1 = 1;
m2 = 1;
L = 1;
I0 = 1;
Ic = m1*L^3/12;
g = 9.81;
G = [0 -m1*g 0];
%% Calculations
syms t x1 x2 x3 x4 ddq1 ddq2 %declare symbolic variables
q1 = sym('q1(t)'); %theta(t)
q2 = sym('q2(t)'); %r(t)
thetai= 25*pi/180; % Initial angle of 25 in radians
omega_ = [0 0 diff(q1,t)]; %define omega as first deriv of theta (vector)
c =  cos(q1); % define c as symbolic cosine function of theta
s =  sin(q1); % define s as symbolic sine function of theta
xC1 = q2*c; %x position of center of link 2
yC1 = q2*s; %y position of center of link 2
rC_ = [xC1 yC1 0]; %vector position of center of link 2
vC_ = diff(rC_,t); % velocity of center of link 2

% Kinetic Energy Link1
T1 = .5*I0*(omega_*omega_.');
% Kinetic Energy Link2
T2 = .5*m2*(vC_*vC_.')+ .5*Ic*(omega_*omega_.');
T = simplify(T1+T2);

%Take Partial Derivative of T wrt dq
Tdq1 = deriv(T,diff(q1,t));
Tdq2 = deriv(T,diff(q2,t));

% Define LHS of equations
LHS1 = diff(Tdq1,t) - deriv(T,q1);
LHS2 = diff(Tdq2,t) - deriv(T,q2);

% Potention Energy
Q1 = deriv(rC_,q1)*G.';
Q2 = deriv(rC_,q2)*G.';

% Combine to form EOMs
eom1 = LHS1 - Q1;
eom2 = LHS2 - Q2;

%Substitute
slist = {diff(q1,t,2), diff(q2,t,2), diff(q1,t), diff(q2,t), q1, q2};    
nlist ={'ddq1', 'ddq2', 'x2', 'x4', 'x1', 'x3'};
eq1 = subs(eom1,slist,nlist);
eq2 = subs(eom2,slist,nlist);

%Solve eqns for second derivs
sol = solve(eq1,eq2,'ddq1','ddq2');
Eq1 = sol.ddq1;
Eq2 = sol.ddq2;
%% ODE45
dx2dt=char(Eq1);
dx4dt=char(Eq2);
%make derivative variables
dx1 = sym('x2'); %dx1=d(theta(t)/dt=x2
dx2 = char(Eq1); % store equation ddths sovled above
dx3 = sym('x4'); %dx3=d(r(t)/dt=x4
dx4 = char(Eq2);  % store equation ddrs sovled above
%store derivative variables in matrix of derivatives
dx_ = [dx1; dx2; dx3; dx4];

%convert derivative variables into a function eomRT_
eomRT_ = matlabFunction(dx_,'vars',{t,[x1;x2;x3;x4]});

%Initial Conditions
%time
t0 = 0; tf = 1; time = [0 tf];
%angles
q10 = 25*pi/180; q20 = .5; 
%position
x0 = [q10 0 q20 0]; 
% ODE45
[tsn,xs] = ode45(eomRT_,0:.001:5,x0);
x1 = xs(:,1);      
x2 = xs(:,2);
x3 = xs(:,3);     
x4 = xs(:,4);  
[ts,xs] = ode45(eomRT_,0:0.1:1,x0); 
Time = (ts);
Theta = xs(:,1).*180/pi;
Omega = xs(:,2).*180/pi;
r = xs(:,3);
Velocity = xs(:,4);
%Display Values
LagrangeResults = table(Time,Theta,Omega,r,Velocity)
%% Animation
figure(2)
text_size = 12;
%link 1
textAx = 4.2;
textAy = 4.2;
text(textAx, textAy,'A','FontSize',text_size)
%link 2
it = 1;
figure(2)
hold on
for i = 1:length(x1)
    clf
    plot_pivot0(1,1,0.08,0)
    plot_slider(1,1,.2,x1(it))
    grid on
    axis([0.1 2 0 2])
    hold on
    xB = 1+cos(x1(it))*(x3(it)+.5);
    yB = 1+sin(x1(it))*(x3(it)+.5);
    xA = 1-cos(x1(it))+x3(it)*cos(x1(it))+.5*cos(x1(it));
    yA = 1-sin(x1(it))+x3(it)*sin(x1(it))+.5*sin(x1(it));
    plot([xA xB],[yA yB],'r','LineWidth',1.5)
    it = it + 15;
    if it > length(x1)
        break
    end
    if yB < 0
        break
    end
    pause(.001)
end

%% Newton 2 DOF Number 1
%Ryan Brown
%10/8/2015
%% Housekeeping
% clc;
clear all;
%% Givens
m1 = 1;
m2 = 1;
L = 1;
IO = 1;
g = 9.81;
%% Calculations
syms t p f21 %declare symbolic variables
r = sym('r(t)'); %declare r as symbolic function of t
theta = sym('theta(t)'); %declare theta as symbolic function of t
omega_ = [0 0 diff(theta,t)]; %define omega as first deriv of theta (vector)
alpha_ = diff(omega_,t); % define alpha as first deriv of omega (vector)

% Link 1
c =  cos(theta); % define c as symbolic cosine function of theta
s =  sin(theta); % define s as symbolic sine function of theta
xP = p*c; %x position of pivot
yP = p*s; %y position of pivot
rP_ = [xP yP 0]; % vector position of pivot
F21_ = [-f21*s f21*c 0]; % reaction force vector at pivot
eom1m_ = -IO*alpha_ + cross(rP_,F21_); % moment vector about pivot = 0
eom1mz = eom1m_(3); % scalar of moment

%Link 2 
xC = r*c; %x position of center of link 2
yC = r*s; %y position of center of link 2
rC_ = [xC yC 0]; %vector position of center of link 2
vC_ = diff(rC_,t); % velocity of center of link 2
aC_ = diff(vC_,t); % acceleration of center of link 2
G2_ = [0 -m2*g 0]; % Gravity force acting on link 2
IC = m2*L^2/12; % moment of inertia about center of link 2

eom2f_ = m2*aC_ + F21_ - G2_; % Force equation of link 2
eom2fx = eom2f_(1); % x component of force
eom2fy = eom2f_(2); % y component of force
eom2m_ = -IC*alpha_ + cross(rP_-rC_,-F21_); % moment equation about center of link 2
eom2mz = eom2m_(3); % scalar of moment about center of link 2

sol = solve(eom2fx, eom2mz, f21, p); %Symbolic solve eoms (f&m) for f21 and p
f21s = sol.f21; % store symbolic equation for f21 as f21s
ps = sol.p; % store symbolic equation for f21 as ps

EqI  = subs(eom1mz,{'f21','p'},{f21s,ps}); 
    %substitute symbolic equationof F21 and p into moment eqn
EqII = subs(eom2fy,{'f21','p'},{f21s,ps});
    %substitute symbolic equation of F21 and p into force eqn

syms x1 x2 x3 x4 real %define symbolic variables for first order eqns
%x_n|fuction
%x1 = theta(t)
%x2 = d(theta(t))/dt = dx1/dt
%x3 = r(t)
%x4 = d(r(t))/dt = dx3/dt

% list for the symbolical variables 
slist={diff('theta(t)',t,2),diff('r(t)',t,2),...
       diff('theta(t)',t),diff('r',t),'theta(t)','r(t)'}; %make variable list for functions
nlist = {'ddth', 'ddr', 'x2', 'x4', 'x1','x3'}; %make variable list for short hands

eq1 = subs(EqI,slist,nlist); %substitute functions for short hands into EqI
eq2 = subs(EqII,slist,nlist); %substitute functions for short hands into EqII

sole = solve(eq1,eq2, 'ddth', 'ddr'); %Solve eq1 and eq2 for ddth and ddr
ddths = sole.ddth; %Store symbolic form of ddth as ddths
ddrs = sole.ddr; %%Store symbolic form of ddr as ddrs

%make derivative variables
dx1 = sym('x2'); %dx1=d(theta(t)/dt=x2
dx2 = char(ddths); % store equation ddths sovled above
dx3 = sym('x4'); %dx3=d(r(t)/dt=x4
dx4 = char(ddrs);  % store equation ddrs sovled above
%store derivative variables in matrix of derivatives
dx_ = [dx1; dx2; dx3; dx4];

%convert derivative variables into a function eomRT_
eomRT_ = matlabFunction(dx_,'vars',{t,[x1;x2;x3;x4]});
%time vector
t0 = 0;  tf = 1; time = [0 tf];
%inital conditions
x0 = [pi/9 0 0.5 0]; % initial conditions
%solve for values and display
[ts,xs] = ode45(eomRT_,0:0.1:1,x0); 
Time = (ts);
Theta = xs(:,1).*180/pi;
Omega = xs(:,2).*180/pi;
r = xs(:,3);
Velocity = xs(:,4);
%Display Values
NewtonResults = table(Time,Theta,Omega,r,Velocity)