%% Force Analysis
% Ryan Brown
% Mechanism 9 Index 1
% Due 9/24/2015
%% Housekeeping
clc, clear all
mag = @(x) sqrt(x(1)^2+x(2)^2+x(3)^2);
%% Givens
% lengths
AB = .22; %m
AC = .08; %m
CD = .20; %m
DE = .60; %m
% Angle and AB speed
phi = 240; %degrees
n = 500; %RPM
% Positions
rB = [-.1100 -.1905 0];
rC = [.0800 0 0];
rD = [-.0616 .1412 0];
rE = [.5215 0 0];
% Calculate Link Vectors
rAB = rB;
rCB = rB-rC;
rCD = rD-rC;
rDE = rE-rD;
%% Velocities
% Point A
vA = [0 0 0]; %Point A is stationary
wAB = [0 0 n*2*pi/60]; %Convert n to Radians
%Point B
vB = vA+cross(wAB,rB);
mag_vB = mag(vB);
%Point C
vC = [0 0 0]; %Point C is stationary
        % Get slope of rCB
        slope = rCB(2)/rCB(1);
        % Negate inverse of slope;
        rec = -1/slope;
        % Vector Perp to rCB
        perp = [1 rec 0];
        % Convert to Unit Vector
        perp = perp./norm(perp);
    %Use perp to get mag of velocity perp to rCB
    mag_vBC = dot(perp,vB);
    %Use mag to get velocity vector for point B tangent wrt point C
    vBCB = perp*mag_vBC;
%Solve cross product for wCB    
magwCB1= vBCB(1)/(-rCB(1));
magwCB2= vBCB(2)/(rCB(2));
%Average the two results
magwCB = (magwCB1+magwCB2)/2;
%Put in vector form
wCB = [0 0 magwCB];
%CD is fixed to CB
wCD = wCB;
%Velocity of point D
vD = vC + cross(wCD,rCD);
%Magnitude of vD
magvD = mag(vD);
%Initiate symbolic variables
syms wDE vE
%Setup Eqauitons for symbolic solving of wDE and vE
eqn1 = 'vE-vD(1)=wDE*rDE(2)' ;
eqn2 = '-vD(2) =wDE*rDE(1)' ;
%Solve
slv = solve(eqn1,eqn2);
wDE = eval(slv.wDE);
vE = eval(slv.vE);
%Put in vector form
wDE = [0 0 wDE];
vE = [vE 0 0];
%% Accelerations
%Point A
aA = [0 0 0]; %Point A is stationary
alphAB = [0 0 0]; %Constant input
%Point B
aB = aA + cross(alphAB,rB) + cross(wAB,cross(wAB,rB));
    %Normal Acceleration of point B
    aBn = cross(wAB,cross(wAB,rB));
%Point C
aC = [0 0 0]; %Point C is stationary
    %Use perp to get mag of acceleration perp to rCB
    mag_aBC = dot(perp,aB);
    %Use mag to get acceleration vector for point B tangent wrt point C
    aBCB = perp*mag_aBC;
%use tangential acceleration aBCB and rCB to find angular acceleration
%Solve cross product for alphCB    
magalphCB1= aBCB(1)/(-rCB(1));
magalphCB2= aBCB(2)/(rCB(2));
%Average the two results
magalphCB = (magalphCB1+magalphCB2)/2;
%Put in vector form
alphCB = [0 0 magalphCB];
%CD is fixed to CB
alphCD = alphCB;
%Point D
aD = aC + cross(alphCD,rCD)+cross(wCD,cross(wCD,rCD));
%Point E
    %Precalculate the normal acceleration for simplicity
    nrml = cross(wDE,cross(wDE,rDE));
%Initiate symbolic variables
syms alphDE aE
%Setup Eqauitons for symbolic solving of wDE and vE
eqn1 = 'aE-aD(1)=alphDE*rDE(2)+nrml(1)' ;
eqn2 = ' 0-aD(2)=alphDE*rDE(1)+nrml(2)' ;
%Solve
slv = solve(eqn1,eqn2);
alphDE = eval(slv.alphDE);
aE = eval(slv.aE);
%Put in vector form
alphDE = [0 0 alphDE];
aE = [aE 0 0];
%% Force Variables Initialization
%Link Attributes
h = 0.01; %m
d = 0.01; %m
%Slider Attributes
wsld = 0.05; %m
hsld = 0.02; %m
%General
rho = 8000; %kg/m^3
g = 9.807; %m/s^2
Fext = 2000; %N (External force on Link)
%Put into vector form
Fext = -sign(vE(1))*[Fext 0 0];
%% Force Calculations
%Inertial, Gravitational, and Moments
%Link 1
%Get mass
m1 = rho*mag(rAB)*h*d;
%Get center of link 1
rC1 = rAB/2;
%Get acceleration at center of link 1
aC1 = aB/2;
%Inertial force link 1
IF1 = -m1 * aC1;
%Gravity on link 1
Grav1 = [0 -m1*g 0];
%Total Force on 1
F1 = IF1 + Grav1;
%Get mass moment of inertia for link 1
IC1 = m1*(mag(rAB)^2+h^2)/12;
%Moment of inertia on link 1
Min1= -IC1*alphAB;
M1 = Min1;
fprintf('Results: \n\n')
fprintf('Force and Moment about Link 1: \n\n')
fprintf('Force on link 1 = [%6.3f, %6.3f, %6.3f] N \n',F1);
fprintf('Moment on link 1 = [%6.3f, %6.3f, %6.3f] Nm \n\n',M1);

%Link 2 (Slider B)
m2 = rho*hsld*wsld*d;
%Get center of link 2
rC2 = rB;
%Get acceleration at center of link 2
aC2 = aB;
%Inertial force link 2
IF2 = -m2 * aC2;
%Gravity on link 2
Grav2 = [0 -m2*g 0];
%Total Force on 2
F2 = IF2 + Grav2;
%Get mass moment of inertia for link 2
IC2 = m2*(hsld^2+wsld^2)/12;
%Moment of inertia on link 2
Min2= -IC2*alphCB;
M2 = Min2;
fprintf('Force and Moment about Link 2 (Slider B): \n\n')
fprintf('Force on link 2 = [%6.3f, %6.3f, %6.3f] N \n',F2);
fprintf('Moment on link 2 = [%6.3f, %6.3f, %6.3f] Nm \n\n',M2);

%Link 3
%Get mass
m3 = rho*mag(rCB)*h*d;
%Get center of link 3
rC3 = rCB/2;
%Get acceleration at center of link 3
aC3 = aBCB/2;
%Inertial force link 3
IF3 = -m3 * aC3;
%Gravity on link 3
Grav3 = [0 -m3*g 0];
%Total Force on 3
F3 = IF3 + Grav3;
%Get mass moment of inertia for link 3
IC3 = m3*(mag(rCB)^2+h^2)/12;
%Moment of inertia on link 3
Min3= -IC3*alphCB;
M3 = Min3;
fprintf('Force and Moment about Link 3: \n\n')
fprintf('Force on link 3 = [%6.3f, %6.3f, %6.3f] N \n',F3);
fprintf('Moment on link 3 = [%6.3f, %6.3f, %6.3f] Nm \n\n',M3);

%Link 4
%Get mass
m4 = rho*mag(rDE)*h*d;
%Get center of link 4
rC4 = rDE/2;
%Get acceleration at center of link 4
aC4 = aBCB/2;
%Inertial force link 4
IF4 = -m4 * aC4;
%Gravity on link 4
Grav4 = [0 -m4*g 0];
%Total Force on 4
F4 = IF4 + Grav4;
%Get mass moment of inertia for link 4
IC4 = m4*(mag(rDE)^2+h^2)/12;
%Moment of inertia on link 3
Min4= -IC4*alphDE;
M4 = Min4;
fprintf('Force and Moment about Link 4: \n\n')
fprintf('Force on link 4 = [%6.3f, %6.3f, %6.3f] N \n',F4);
fprintf('Moment on link 4 = [%6.3f, %6.3f, %6.3f] Nm \n\n',M4);

%Link 5 (Slider E)
m5 = rho*hsld*wsld*d;
%Get center of link 5
rC5 = rE;
%Get acceleration at center of link 5
aC5 = aE;
%Inertial force link 5
IF5 = -m5 * aC5;
%Gravity on link 5
Grav5 = [0 -m5*g 0];
%Total Force on 5
F5 = IF5 + Grav5;
%Get mass moment of inertia for link 5
IC5 = m5*(hsld^2+wsld^2)/12;
%Moment of inertia on link 5
M5= -IC5*[0 0 0];
fprintf('Force and Moment about Link 5 (Slider E): \n\n')
fprintf('Force on link 5 = [%6.3f, %6.3f, %6.3f] N \n',F5);
fprintf('Moment on link 5 = [%6.3f, %6.3f, %6.3f] Nm \n\n',M5);

%Reaction Forces
%Normal Force at E
syms F05y
F05 = [0 F05y 0];
eqME54 = cross(rDE,F05+Fext+F5)+cross(rC4-rE,F4)+M4;
eqME54_1 = eqME54(3);
solF05 = solve (eqME54_1);
F05ys = eval(solF05);
F05s = [0 F05ys 0];
fprintf('Normal force at Slider E: \n\n');
fprintf('F05 = [%6.3f, %6.3f, %6.3f] N \n\n',F05s);
%Reaction Force at E
syms F45x F45y
F45 = [F45x F45y 0];
eqF5x= (F05+F45+F5+Fext);
eqF5x_1= eqF5x(1);
eqME4 = (cross(rDE,-F45)+cross(rC4-rE,F4)+M4);
eqME4_1 = eqME4(3);
solF45 = solve(eqF5x_1, eqME4_1);
F45s = [eval(solF45.F45x), eval(solF45.F45y), 0];
fprintf('Reaction force at Slider E: \n\n');
fprintf('F45 = [%6.3f, %6.3f, %6.3f] N \n\n',F45s);
%Reaction Force at D
syms F34x F34y
F34 = [F34x F34y 0];
eqF45y= (F34+F4+F5+Fext);
eqF45y_1= eqF45y(2);
eqME4 = (cross(rDE,F34)+cross(rC4-rE,F4)+M4);
eqME4_1 = eqME4(3);
solF34 = solve(eqF45y_1, eqME4_1);
F34s = [eval(solF34.F34x), eval(solF34.F34y), 0];
fprintf('Reaction force at D: \n\n');
fprintf('F45 = [%6.3f, %6.3f, %6.3f] N \n\n',F34s);
%Reaction Force at C, A and  B
syms F03x F03y F12x F12y
F03 = [F03x F03y 0];
F12 = [F12x F12y 0];
eqF23 = F03+F3-F34s+F2+F12;
eqF23x= eqF23(1);
eqF23y= eqF23(2);
eqMB23 = cross(rD-rB,-F34s)+cross(rC-rB,F03)+cross(rC3-rB,F3)+M2+M3;
eqMB23_1 = eqMB23(3);
eqF2BC= dot((F2+F12),(rB-rC));
solF03=solve(eqMB23_1,eqF23x,eqF23y,eqF2BC);
F03s = [eval(solF03.F03x),eval(solF03.F03y),0];
F12s = [eval(solF03.F12x),eval(solF03.F12y),0];
F23 = F12s + F2;
fprintf('Reaction force at C: \n\n');
fprintf('F03 = [%6.3f, %6.3f, %6.3f] N \n\n',F03s);
fprintf('Reaction force at B: \n\n');
fprintf('F23 = [%6.3f, %6.3f, %6.3f] N \n\n',F23);
fprintf('Reaction force at A: \n\n');
fprintf('F23 = [%6.3f, %6.3f, %6.3f] N \n\n',F12s);
%Equilibrium Moment
MM = -cross(rB,-F12s)-cross(rC1,F1)-M1;
fprintf('Equilibrium Moment at Motor: \n\n');
fprintf('Meq = [%6.3f, %6.3f, %6.3f] Nm \n\n',MM);